# **DJYTL Wallet - Browser Extension Setup Guide**  
📦 **Manual Installation from ZIP File**  

This guide will help you install the **DJYTL Wallet** extension manually in Chrome, Edge, Firefox, or other supported browsers.  

---

## **📥 Step 1: Download the ZIP File**  
1. Download the **`djytl-wallet.zip`** file from the provided link.  
2. Save it to a known location (e.g., `Downloads` folder). 

---

## **📂 Step 2: Extract the ZIP File**  
1. **Right-click** the downloaded ZIP file.  
2. Select **"Extract All..."** (Windows) or double-click (Mac).  
3. Choose a destination folder (e.g., `djytl-wallet-extracted`).

---

## **🌐 Step 3: Install in Your Browser**  

### **🟢 For Chrome / Edge / Brave / Opera (Chromium-based browsers)**  
1. Open Chrome and go to:  
   ```
   chrome://extensions
   ```  
   *(or `edge://extensions` for Edge, `brave://extensions` for Brave)*  

2. **Enable Developer Mode** (toggle switch in the top-right corner).  

   ![Enable Developer Mode](screenshots/enable-developer-mode.png)  

3. Click **"Load Unpacked"**.  

4. Select the **extracted folder** (`djytl-wallet-extracted`).  

5. The extension should now appear in your toolbar.  

---

### **🟠 For Firefox**  
1. Open Firefox and go to:  
   ```
   about:debugging
   ```  
2. Click **"This Firefox"** (left sidebar).  

3. Click **"Load Temporary Add-on"**.  
4. Select the **`manifest.json`** file inside the extracted folder.  

   ![Load Temporary Add-on](screenshots/firefox-extension.png)  

⚠️ **Note:** Firefox extensions loaded this way are **temporary** and will disappear after restarting the browser. For permanent installation, you need a signed `.xpi` file.  

---

## **🔧 Troubleshooting**  
❌ **"Extension is invalid" error?**  
- Make sure you extracted the ZIP file correctly.  
- Ensure you selected the **folder**, not the ZIP file.  

❌ **Extension disappears after restart?** (Chrome)  
- Go back to `chrome://extensions` and re-enable it.  

---

## **🔒 Security Notice**  
- Only install extensions from **trusted sources**.  
- If prompted for permissions, review them carefully.  

---

### **🎉 Done!**  
DJYTL Wallet is now installed and ready to use. 🚀  